/*
 * Decompiled with CFR 0.152.
 */
package com.mathochist.mazegame.World.Objects;

import com.badlogic.gdx.Gdx;
import com.badlogic.gdx.graphics.g2d.Sprite;
import com.badlogic.gdx.graphics.g2d.SpriteBatch;
import com.badlogic.gdx.graphics.g2d.TextureAtlas;
import com.mathochist.mazegame.Entities.MapEntity;
import com.mathochist.mazegame.Entities.Player;
import com.mathochist.mazegame.Entities.PlayerInventory.InventoryObject;
import com.mathochist.mazegame.Main;
import com.mathochist.mazegame.Rendering.RenderBuffer;
import com.mathochist.mazegame.Rendering.RenderObject;
import com.mathochist.mazegame.UI.Hud;
import com.mathochist.mazegame.UI.Speech.SpeechType;
import com.mathochist.mazegame.World.GameWorld;

public class VendingMachine
extends MapEntity {
    private boolean used;
    private static final long INTERACTION_COOLDOWN_MS = 2000L;
    private long lastInteractionTime = 0L;

    public VendingMachine(Main game, SpriteBatch batch, TextureAtlas atlas, Integer TileX, Integer TileY, Integer Width, Integer Height, Boolean collidable) {
        super(game, batch, atlas, "vending_machine", TileX.intValue(), TileY.intValue(), Width.intValue(), Height.intValue(), collidable);
        this.used = game.getPlayerInventory().hasItem(InventoryObject.ENERGY_DRINK);
    }

    @Override
    public void render(GameWorld world, RenderBuffer renderBuffer) {
        TextureAtlas.AtlasRegion vmRegion = super.getAtlas().findRegion(super.getRegionName());
        Sprite vmSprite = new Sprite(vmRegion);
        vmSprite.setPosition(super.getTileX() * (float)world.getMap().getTileWidth(), (float)Gdx.graphics.getHeight() - ((super.getTileY() + 1.0f) * (float)world.getMap().getTileHeight() + (float)world.tileDrawYOffset + world.getDeltaViewportHeight()));
        renderBuffer.addToBuffer(new RenderObject(vmSprite, super.getBatch(), (int)super.getTileY() + 2));
    }

    @Override
    public boolean onInteract(Player p, GameWorld world, Hud worldHud) {
        long currentTime = System.currentTimeMillis();
        if (currentTime - this.lastInteractionTime < 2000L) {
            return true;
        }
        this.lastInteractionTime = currentTime;
        if (this.used) {
            worldHud.getSpeechBubbleManager().removeBubblesOfType(SpeechType.NPC_SPEECH);
            worldHud.getSpeechBubbleManager().createSpeechBubble(SpeechType.NPC_SPEECH, "The vending machine is empty.", 2000);
            return true;
        }
        this.used = true;
        this.game.getPlayerInventory().addItem(InventoryObject.ENERGY_DRINK);
        worldHud.getSpeechBubbleManager().removeBubblesOfType(SpeechType.NPC_SPEECH);
        worldHud.getSpeechBubbleManager().createSpeechBubble(SpeechType.NPC_SPEECH, "You got an energy drink, You are suddenly feeling fast!", 2000);
        this.game.getEventsCounter().vendingMachineEvent();
        return true;
    }

    @Override
    public void onInteractEnd(Player p, GameWorld world) {
    }

    @Override
    public boolean onCollision(GameWorld world) {
        return false;
    }
}

