/*
 * Decompiled with CFR 0.152.
 */
package com.mathochist.mazegame.World.Objects;

import com.badlogic.gdx.Gdx;
import com.badlogic.gdx.graphics.g2d.Sprite;
import com.badlogic.gdx.graphics.g2d.SpriteBatch;
import com.badlogic.gdx.graphics.g2d.TextureAtlas;
import com.mathochist.mazegame.Entities.MapEntity;
import com.mathochist.mazegame.Entities.Player;
import com.mathochist.mazegame.Entities.PlayerInventory.InventoryObject;
import com.mathochist.mazegame.Main;
import com.mathochist.mazegame.Rendering.RenderBuffer;
import com.mathochist.mazegame.Rendering.RenderObject;
import com.mathochist.mazegame.UI.Hud;
import com.mathochist.mazegame.World.ExitConditions;
import com.mathochist.mazegame.World.ExitTile;
import com.mathochist.mazegame.World.GameWorld;

public class LibraryFloorHole
extends MapEntity {
    private boolean visible;

    public LibraryFloorHole(Main game, SpriteBatch batch, TextureAtlas atlas, Integer TileX, Integer TileY, Integer Width, Integer Height, Boolean collidable) {
        super(game, batch, atlas, "hole_floor", TileX.intValue(), TileY.intValue(), Width.intValue(), Height.intValue(), collidable);
        this.visible = game.getPlayerInventory().hasItem(InventoryObject.KEYCARD);
    }

    @Override
    public boolean onInteract(Player p, GameWorld world, Hud worldHud) {
        return false;
    }

    @Override
    public void onInteractEnd(Player p, GameWorld world) {
    }

    @Override
    public void render(GameWorld world, RenderBuffer renderBuffer) {
        if (!this.visible) {
            return;
        }
        TextureAtlas.AtlasRegion keycardRegion = super.getAtlas().findRegion(super.getRegionName());
        Sprite keycardSprite = new Sprite(keycardRegion);
        keycardSprite.setPosition(super.getTileX() * (float)world.getMap().getTileWidth(), (float)Gdx.graphics.getHeight() - ((super.getTileY() + 1.0f) * (float)world.getMap().getTileHeight() + (float)world.tileDrawYOffset + world.getDeltaViewportHeight()));
        renderBuffer.addToBuffer(new RenderObject(keycardSprite, super.getBatch(), (int)super.getTileY() + 1));
    }

    @Override
    public boolean onCollision(GameWorld world) {
        this.visible = this.game.getPlayerInventory().hasItem(InventoryObject.KEYCARD);
        if (!this.visible) {
            return false;
        }
        ExitConditions conditions = new ExitConditions(new String[0], new String[0], new String[0], -1);
        ExitTile exit = new ExitTile(super.getTileX(), super.getTileY(), "com.mathochist.mazegame.Screens.Game.LibraryBasementScreen", 12.0f, 5.0f, conditions);
        world.loadNewWorld(exit);
        return true;
    }
}

