/*
 * Decompiled with CFR 0.152.
 */
package com.mathochist.mazegame.World;

import com.badlogic.gdx.Gdx;
import com.badlogic.gdx.audio.Music;
import com.badlogic.gdx.files.FileHandle;
import com.badlogic.gdx.graphics.Color;
import com.badlogic.gdx.graphics.g2d.Sprite;
import com.badlogic.gdx.graphics.g2d.SpriteBatch;
import com.badlogic.gdx.graphics.g2d.TextureAtlas;
import com.badlogic.gdx.graphics.g2d.TextureRegion;
import com.badlogic.gdx.graphics.glutils.ShaderProgram;
import com.badlogic.gdx.graphics.glutils.ShapeRenderer;
import com.badlogic.gdx.utils.Json;
import com.badlogic.gdx.utils.JsonValue;
import com.badlogic.gdx.utils.viewport.FitViewport;
import com.mathochist.mazegame.Entities.MapEntity;
import com.mathochist.mazegame.Entities.Player;
import com.mathochist.mazegame.Entities.PlayerInventory.Inventory;
import com.mathochist.mazegame.Main;
import com.mathochist.mazegame.Rendering.RenderBuffer;
import com.mathochist.mazegame.Rendering.RenderObject;
import com.mathochist.mazegame.Rendering.Shader;
import com.mathochist.mazegame.Screens.Game.BaseGameScreen;
import com.mathochist.mazegame.UI.Speech.SpeechType;
import com.mathochist.mazegame.World.ExitConditions;
import com.mathochist.mazegame.World.ExitTile;
import com.mathochist.mazegame.World.GameMap;
import com.mathochist.mazegame.World.Objects.Utils;
import com.mathochist.mazegame.World.Tile;
import java.util.ArrayList;
import java.util.Arrays;

public class GameWorld {
    private final Main game;
    private final BaseGameScreen parentScreen;
    private final GameMap currentMap;
    private final TextureAtlas textureAtlas;
    private final SpriteBatch screenBatch;
    private Shader shader;
    private ShaderProgram shaderProgram;
    private Music backgroundMusic;
    private final Tile[][] mapArray;
    private final MapEntity[] mapEntities;
    private final ShapeRenderer shapeRenderer = new ShapeRenderer();
    public int tileDrawYOffset = 0;
    private float deltaViewportHeight;
    private boolean debug = false;

    public GameWorld(Main game, BaseGameScreen parentScreen, FileHandle mapFile, SpriteBatch gameSpriteBatch) {
        this.game = game;
        this.parentScreen = parentScreen;
        this.screenBatch = gameSpriteBatch;
        this.currentMap = new GameMap(mapFile);
        if (this.backgroundMusic == null) {
            this.backgroundMusic = this.currentMap.getBackgroundMusic();
            if (this.backgroundMusic != null) {
                this.backgroundMusic.setLooping(true);
                this.backgroundMusic.setVolume(0.5f);
                this.backgroundMusic.play();
            }
        }
        this.textureAtlas = new TextureAtlas(Gdx.files.internal(this.currentMap.getTextureAtlasFile()));
        TextureRegion[] tileTextures = new TextureRegion[this.currentMap.getTilesetRegionNames().length];
        for (int i = 0; i < this.currentMap.getTilesetRegionNames().length; ++i) {
            System.out.println(this.currentMap.getTilesetRegionNames()[i]);
            tileTextures[i] = this.textureAtlas.findRegion(this.currentMap.getTilesetRegionNames()[i]);
        }
        this.mapArray = new Tile[this.currentMap.getMapHeight()][this.currentMap.getMapWidth()];
        for (int j = 0; j < this.currentMap.getMapHeight(); ++j) {
            for (int i = 0; i < this.currentMap.getMapWidth(); ++i) {
                this.mapArray[j][i] = new Tile(this.currentMap.getTilesetRegionNames()[this.currentMap.getMapMatrix()[j][i]], this.isTileCollidable(i, j), new Sprite(tileTextures[0]));
                this.mapArray[j][i].getSprite().setRegion(tileTextures[this.currentMap.getMapMatrix()[j][i]]);
                this.mapArray[j][i].getSprite().setPosition(i * this.currentMap.getTileWidth(), Gdx.graphics.getHeight() - (j * this.currentMap.getTileHeight() + this.tileDrawYOffset));
            }
        }
        this.mapEntities = new MapEntity[this.currentMap.getNumberOfMapEntities()];
        JsonValue entitiesData = this.currentMap.getObjectsLayer();
        for (JsonValue entityData : entitiesData) {
            int[][] positions;
            String entityKey = entityData.name();
            System.out.println("Loaded entity: " + entityKey);
            int width = entityData.getInt("width");
            int height = entityData.getInt("height");
            boolean collidable = entityData.getBoolean("collidable");
            JsonValue positionData = entityData.get("positions");
            Json json = new Json();
            block4: for (int[] pos : positions = json.readValue(int[][].class, positionData)) {
                MapEntity entity = Utils.instantiate(entityKey, MapEntity.class, this.game, this.screenBatch, this.textureAtlas, pos[0], pos[1], width, height, collidable);
                for (int k = 0; k < this.mapEntities.length; ++k) {
                    if (this.mapEntities[k] != null) continue;
                    this.mapEntities[k] = entity;
                    continue block4;
                }
            }
            System.out.println("Total entities loaded: " + this.mapEntities.length);
        }
        this.shader = this.currentMap.getMapShader();
        if (this.shader != null) {
            this.setShader(this.shader);
        }
    }

    public void setBackgroundMusic(Music music) {
        if (this.backgroundMusic != null) {
            this.backgroundMusic.stop();
        }
        this.backgroundMusic = music;
    }

    public GameMap getMap() {
        return this.currentMap;
    }

    public TextureAtlas getTextureAtlas() {
        return this.textureAtlas;
    }

    public void setShader(Shader shader) {
        ShaderProgram.pedantic = false;
        this.shader = shader;
        this.shaderProgram = new ShaderProgram(shader.getVertexShaderCode(), shader.getFragmentShaderCode());
        this.screenBatch.setShader(this.shaderProgram);
        System.out.println(this.shaderProgram.getLog());
    }

    public ShaderProgram getShaderProgram() {
        return this.shaderProgram;
    }

    public void render(FitViewport viewport, RenderBuffer renderBuffer) {
        if (this.shaderProgram != null && this.shaderProgram.isCompiled()) {
            this.shaderProgram.bind();
            this.shaderProgram.setUniformf("u_viewport", (float)viewport.getScreenX(), (float)viewport.getScreenY(), (float)viewport.getScreenWidth(), (float)viewport.getScreenHeight());
            this.shaderProgram.setUniformf("u_resolution", (float)Gdx.graphics.getWidth(), (float)Gdx.graphics.getHeight());
        }
        for (int j = 0; j < this.currentMap.getMapHeight(); ++j) {
            for (int i = 0; i < this.currentMap.getMapWidth(); ++i) {
                renderBuffer.addToBuffer(new RenderObject(this.mapArray[j][i].getSprite(), this.screenBatch, j));
            }
        }
        for (MapEntity entity : this.mapEntities) {
            if (entity == null) continue;
            entity.render(this, renderBuffer);
        }
    }

    public void renderDebugLayer() {
        if (Gdx.input.isKeyJustPressed(133)) {
            this.debug = !this.debug;
        }
        if (this.debug) {
            for (int j = 0; j < this.currentMap.getMapHeight(); ++j) {
                for (int i = 0; i < this.currentMap.getMapWidth(); ++i) {
                    if (!this.mapArray[j][i].isCollidable().booleanValue()) continue;
                    this.shapeRenderer.setProjectionMatrix(this.screenBatch.getProjectionMatrix());
                    this.shapeRenderer.begin(ShapeRenderer.ShapeType.Filled);
                    this.shapeRenderer.setColor(new Color(1.0f, 0.0f, 0.0f, 0.4f));
                    float x = i * this.currentMap.getTileWidth();
                    float y = Gdx.graphics.getHeight() - (j * this.currentMap.getTileHeight() + this.tileDrawYOffset);
                    this.shapeRenderer.rect(x, y - this.deltaViewportHeight, this.currentMap.getTileWidth(), this.currentMap.getTileHeight());
                    this.shapeRenderer.end();
                }
            }
            for (MapEntity entity : this.mapEntities) {
                if (entity == null) continue;
                float[] bbox = entity.getBBox();
                this.shapeRenderer.setProjectionMatrix(this.screenBatch.getProjectionMatrix());
                this.shapeRenderer.begin(ShapeRenderer.ShapeType.Filled);
                this.shapeRenderer.setColor(new Color(0.0f, 0.0f, 1.0f, 0.4f));
                float x = bbox[0] * (float)this.currentMap.getTileWidth();
                float y = (float)Gdx.graphics.getHeight() - (bbox[1] * (float)this.currentMap.getTileHeight() + (float)this.tileDrawYOffset) - bbox[3] * (float)this.currentMap.getTileHeight();
                this.shapeRenderer.rect(x, y - this.deltaViewportHeight, bbox[2] * (float)this.currentMap.getTileWidth(), bbox[3] * (float)this.currentMap.getTileHeight());
                this.shapeRenderer.end();
            }
        }
    }

    public void render_collision_layer(Player p) {
        float tx;
        float y;
        float x;
        float ty;
        float[] playerTilePos = this.pixelCoordsToTileIndex(p.getX(), p.getY());
        boolean[] collisionLayer = this.getCollisionLayer(p.getX(), p.getY());
        this.shapeRenderer.setProjectionMatrix(this.screenBatch.getProjectionMatrix());
        this.shapeRenderer.begin(ShapeRenderer.ShapeType.Filled);
        this.shapeRenderer.setColor(new Color(0.0f, 1.0f, 0.0f, 0.4f));
        float px = playerTilePos[0];
        float py = playerTilePos[1];
        if (collisionLayer[0] && (ty = py - 1.0f) >= 0.0f) {
            x = px * (float)this.currentMap.getTileWidth();
            y = (float)Gdx.graphics.getHeight() - (ty * (float)this.currentMap.getTileHeight() + (float)this.tileDrawYOffset);
            this.shapeRenderer.rect(x, y, this.currentMap.getTileWidth(), this.currentMap.getTileHeight());
        }
        if (collisionLayer[1] && (ty = py + 1.0f) < (float)this.currentMap.getMapHeight()) {
            x = px * (float)this.currentMap.getTileWidth();
            y = (float)Gdx.graphics.getHeight() - (ty * (float)this.currentMap.getTileHeight() + (float)this.tileDrawYOffset);
            this.shapeRenderer.rect(x, y, this.currentMap.getTileWidth(), this.currentMap.getTileHeight());
        }
        if (collisionLayer[2] && (tx = px - 1.0f) >= 0.0f) {
            x = tx * (float)this.currentMap.getTileWidth();
            y = (float)Gdx.graphics.getHeight() - (py * (float)this.currentMap.getTileHeight() + (float)this.tileDrawYOffset);
            this.shapeRenderer.rect(x, y, this.currentMap.getTileWidth(), this.currentMap.getTileHeight());
        }
        if (collisionLayer[3] && (tx = px + 1.0f) < (float)this.currentMap.getMapWidth()) {
            x = tx * (float)this.currentMap.getTileWidth();
            y = (float)Gdx.graphics.getHeight() - (py * (float)this.currentMap.getTileHeight() + (float)this.tileDrawYOffset);
            this.shapeRenderer.rect(x, y, this.currentMap.getTileWidth(), this.currentMap.getTileHeight());
        }
        this.shapeRenderer.end();
    }

    public boolean[] getCollisionLayer(float playerXPixels, float playerYPixels) {
        float[] playerTilePos = this.pixelCoordsToTileIndex(playerXPixels, playerYPixels + this.deltaViewportHeight);
        boolean isTransition = this.checkForWorldTransition(playerTilePos);
        if (isTransition) {
            return new boolean[]{false, false, false, false};
        }
        boolean[] entityCollisionLayer = this.getCollisionLayerWithEntities(playerTilePos);
        return new boolean[]{this.mapArray[(int)Math.floor(playerTilePos[1])][Math.round(playerTilePos[0])].isCollidable() != false || entityCollisionLayer[0], this.mapArray[(int)Math.ceil(playerTilePos[1])][Math.round(playerTilePos[0])].isCollidable() != false || entityCollisionLayer[1], this.mapArray[Math.round(playerTilePos[1])][(int)Math.floor(playerTilePos[0])].isCollidable() != false || entityCollisionLayer[2], this.mapArray[Math.round(playerTilePos[1])][(int)Math.ceil(playerTilePos[0])].isCollidable() != false || entityCollisionLayer[3]};
    }

    private boolean checkForWorldTransition(float[] playerTilePos) {
        ExitTile[] exitTiles;
        for (ExitTile exitTile : exitTiles = this.currentMap.getExitPoints()) {
            if (Math.round(exitTile.getX()) != Math.round(playerTilePos[0]) || Math.round(exitTile.getY()) != Math.round(playerTilePos[1])) continue;
            System.out.println("On exit tile");
            System.out.println(exitTile);
            this.loadNewWorld(exitTile);
            return true;
        }
        return false;
    }

    private boolean[] getCollisionLayerWithEntities(float[] playerTilePos) {
        boolean[] collisionLayer = new boolean[]{false, false, false, false};
        for (MapEntity entity : this.mapEntities) {
            boolean[] entityCollisionLayer = new boolean[]{false, false, false, false};
            if (entity == null) continue;
            float[] entityBBox = entity.getBBox();
            entityCollisionLayer[0] = Math.floor(playerTilePos[1]) <= (double)(entityBBox[1] + entityBBox[3]) && (float)Math.round(playerTilePos[0]) >= entityBBox[0] && (float)Math.round(playerTilePos[0]) < entityBBox[0] + entityBBox[2] && Math.floor(playerTilePos[1]) - 1.0 >= (double)entityBBox[1];
            entityCollisionLayer[1] = Math.floor(playerTilePos[1]) >= (double)entityBBox[1] && (float)Math.round(playerTilePos[0]) >= entityBBox[0] && (float)Math.round(playerTilePos[0]) < entityBBox[0] + entityBBox[2] && Math.floor(playerTilePos[1]) + 1.0 <= (double)(entityBBox[1] + entityBBox[3]);
            entityCollisionLayer[2] = Math.ceil(playerTilePos[0]) <= (double)(entityBBox[0] + entityBBox[2]) && (float)Math.round(playerTilePos[1]) > entityBBox[1] && (float)Math.round(playerTilePos[1]) <= entityBBox[1] + entityBBox[3] && Math.ceil(playerTilePos[0]) - 1.0 >= (double)entityBBox[0];
            boolean bl = entityCollisionLayer[3] = Math.ceil(playerTilePos[0]) >= (double)entityBBox[0] && (float)Math.round(playerTilePos[1]) > entityBBox[1] && (float)Math.round(playerTilePos[1]) <= entityBBox[1] + entityBBox[3] && Math.ceil(playerTilePos[0]) + 1.0 <= (double)(entityBBox[0] + entityBBox[2]);
            if (entityCollisionLayer[0] || entityCollisionLayer[1] || entityCollisionLayer[2] || entityCollisionLayer[3]) {
                entity.onCollision(this);
            }
            if (!entity.isCollidable()) continue;
            collisionLayer[0] = collisionLayer[0] || entityCollisionLayer[0];
            collisionLayer[1] = collisionLayer[1] || entityCollisionLayer[1];
            collisionLayer[2] = collisionLayer[2] || entityCollisionLayer[2];
            collisionLayer[3] = collisionLayer[3] || entityCollisionLayer[3];
        }
        return collisionLayer;
    }

    public void dispose() {
        this.textureAtlas.dispose();
        if (this.shaderProgram != null) {
            this.shaderProgram.dispose();
        }
    }

    public float[] pixelCoordsToTileIndex(float pixelCoordX, float pixelCoordY) {
        float tileX = pixelCoordX / (float)this.currentMap.getTileWidth();
        float tileY = ((float)Gdx.graphics.getHeight() - pixelCoordY - (float)this.tileDrawYOffset) / (float)this.currentMap.getTileHeight();
        return new float[]{tileX, tileY};
    }

    private boolean isTileCollidable(int tileX, int tileY) {
        int tileIndex = this.currentMap.getMapMatrix()[tileY][tileX];
        return Arrays.stream(this.currentMap.getCollisionTiles()).anyMatch(tile -> tile == tileIndex);
    }

    public float[] getPixelBoundsOfTile(int tileX, int tileY) {
        float pixelX = tileX * this.currentMap.getTileWidth();
        float pixelY = tileY * this.currentMap.getTileHeight();
        return new float[]{pixelX, pixelY, this.currentMap.getTileWidth(), this.currentMap.getTileHeight()};
    }

    public int[] getSpawnPointPixels() {
        float[] spawnPixelCoords = this.getPixels(this.currentMap.getSpawnX(), this.currentMap.getSpawnY());
        return new int[]{(int)spawnPixelCoords[0], (int)spawnPixelCoords[1]};
    }

    public float[] getPixels(float tileX, float tileY) {
        float x = tileX * (float)this.currentMap.getTileWidth();
        float y = (float)Gdx.graphics.getHeight() - (tileY * (float)this.currentMap.getTileHeight() + (float)this.tileDrawYOffset);
        return new float[]{x, y - this.deltaViewportHeight};
    }

    public void scaleWorld(float oldViewportHeight, float newViewportHeight) {
        this.deltaViewportHeight = newViewportHeight - oldViewportHeight;
    }

    public static double getTileDistance(float tileX1, float tileY1, float tileX2, float tileY2) {
        return Math.sqrt((tileX1 - tileX2) * (tileX1 - tileX2) + (tileY1 - tileY2) * (tileY1 - tileY2));
    }

    public static double distanceFromBBox(float[] entityBBox, float tileX1, float tileY1) {
        float rx_min = entityBBox[0];
        float rx_max = entityBBox[0] + entityBBox[2];
        float ry_min = entityBBox[1];
        float ry_max = entityBBox[1] + entityBBox[3];
        if (rx_min <= tileX1 && tileX1 <= rx_max && ry_min <= tileY1 && tileY1 <= ry_max) {
            return Math.min(Math.min(tileX1 - rx_min, rx_max - tileX1), Math.min(tileY1 - ry_min, ry_max - tileY1));
        }
        double dx = Math.max(0.0f, Math.max(rx_min - tileX1, tileX1 - rx_max));
        double dy = Math.max(0.0f, Math.max(ry_min - tileY1, tileY1 - ry_max));
        return Math.sqrt(dx * dx + dy * dy);
    }

    public MapEntity[] getMapEntitiesInRadius(float tileX, float tileY, double radius) {
        ArrayList<MapEntity> array_output = new ArrayList<MapEntity>();
        for (MapEntity entity : this.mapEntities) {
            double dist = GameWorld.distanceFromBBox(entity.getBBox(), tileX, tileY);
            if (!(dist <= radius)) continue;
            array_output.add(entity);
        }
        MapEntity[] output = new MapEntity[array_output.size()];
        array_output.toArray(output);
        return output;
    }

    private String[] beautifyItemNames(String[] itemKeys) {
        String[] beautifiedNames = new String[itemKeys.length];
        for (int i = 0; i < itemKeys.length; ++i) {
            String item = itemKeys[i];
            item = item.replace("_", " ");
            String[] words = item.split(" ");
            StringBuilder capitalizedItem = new StringBuilder();
            for (String word : words) {
                capitalizedItem.append(Character.toUpperCase(word.charAt(0))).append(word.substring(1)).append(" ");
            }
            beautifiedNames[i] = capitalizedItem.toString().trim();
        }
        return beautifiedNames;
    }

    public void loadNewWorld(ExitTile targetExit) {
        Inventory playerInventory;
        ExitConditions conditions = targetExit.getConditions();
        if (!conditions.hasRequiredItems(playerInventory = this.game.getPlayerInventory())) {
            System.out.println("Missing required items to exit");
            String[] missingItems = conditions.getMissingItems(playerInventory);
            CharSequence[] beautifiedMissingItems = this.beautifyItemNames(missingItems);
            String missingItemsList = String.join((CharSequence)", ", beautifiedMissingItems);
            this.parentScreen.getGameHud().getSpeechBubbleManager().removeBubblesOfType(SpeechType.NPC_SPEECH);
            this.parentScreen.getGameHud().getSpeechBubbleManager().createSpeechBubble(SpeechType.NPC_SPEECH, "You need " + missingItemsList + " before you can exit here!", 2000);
            if (targetExit.getX() == 0.0f) {
                this.parentScreen.getPlayer().setPosition(this.parentScreen.getPlayer().getX() + (float)this.getMap().getTileWidth() / 2.0f, this.parentScreen.getPlayer().getY());
            } else if (targetExit.getX() == (float)(this.getMap().getMapWidth() - 1)) {
                this.parentScreen.getPlayer().setPosition(this.parentScreen.getPlayer().getX() - (float)this.getMap().getTileWidth() / 2.0f, this.parentScreen.getPlayer().getY());
            } else if (targetExit.getY() == 0.0f) {
                this.parentScreen.getPlayer().setPosition(this.parentScreen.getPlayer().getX(), this.parentScreen.getPlayer().getY() - (float)this.getMap().getTileHeight() / 2.0f);
            } else if (targetExit.getY() == (float)(this.getMap().getMapHeight() - 1)) {
                this.parentScreen.getPlayer().setPosition(this.parentScreen.getPlayer().getX(), this.parentScreen.getPlayer().getY() + (float)this.getMap().getTileHeight() / 2.0f);
            }
            return;
        }
        this.parentScreen.setPrepareTransition(true);
        try {
            Thread.sleep(100L);
        }
        catch (InterruptedException e) {
            e.printStackTrace();
        }
        this.game.getScreen().dispose();
        System.out.println("Loading new world: " + targetExit.getTargetMap());
        BaseGameScreen newScreen = Utils.instantiate(targetExit.getTargetMap(), BaseGameScreen.class, this.game, Float.valueOf(targetExit.getTargetX()), Float.valueOf(targetExit.getTargetY()));
        if (!newScreen.getWorld().getMap().getBackgroundMusicFile().equals("continue")) {
            if (this.backgroundMusic != null) {
                this.backgroundMusic.stop();
            }
        } else {
            newScreen.getWorld().setBackgroundMusic(this.backgroundMusic);
        }
        this.game.setScreen(newScreen);
    }

    public boolean triggerInteractionByPixel(float pixelX, float pixelY, double tileRadius, Player p) {
        float[] tileCoords = this.pixelCoordsToTileIndex(pixelX, pixelY + this.deltaViewportHeight);
        return this.triggerInteraction(tileCoords[0], tileCoords[1], tileRadius, p);
    }

    public boolean triggerInteraction(float tileX, float tileY, double radius, Player p) {
        MapEntity[] entitiesOutOfRange;
        MapEntity[] nearbyEntities = this.getMapEntitiesInRadius(tileX, tileY, radius);
        for (MapEntity entity : entitiesOutOfRange = Utils.complementOfSubArray(this.mapEntities, nearbyEntities)) {
            entity.onInteractEnd(p, this);
        }
        for (MapEntity entity : nearbyEntities) {
            if (!entity.onInteract(p, this, ((BaseGameScreen)this.game.getScreen()).getGameHud())) continue;
            return true;
        }
        return false;
    }

    public float getDeltaViewportHeight() {
        return this.deltaViewportHeight;
    }

    public Music getBackgroundMusic() {
        return this.backgroundMusic;
    }
}

