/*
 * Decompiled with CFR 0.152.
 */
package com.mathochist.mazegame.World;

import com.badlogic.gdx.Gdx;
import com.badlogic.gdx.audio.Music;
import com.badlogic.gdx.files.FileHandle;
import com.badlogic.gdx.utils.Json;
import com.badlogic.gdx.utils.JsonReader;
import com.badlogic.gdx.utils.JsonValue;
import com.mathochist.mazegame.Rendering.Shader;
import com.mathochist.mazegame.World.ExitConditions;
import com.mathochist.mazegame.World.ExitTile;
import java.util.Objects;

public class GameMap {
    private FileHandle mapFile;
    private JsonReader jsonReader;
    private JsonValue mapData;

    public GameMap(FileHandle mapFile) {
        this.mapFile = mapFile;
        this.jsonReader = new JsonReader();
        this.mapData = this.jsonReader.parse(this.mapFile);
    }

    public FileHandle getMapFile() {
        return this.mapFile;
    }

    public JsonValue getMapData() {
        return this.mapData;
    }

    public String getMapName() {
        return this.mapData.get("metadata").getString("name");
    }

    public String getMapAuthor() {
        return this.mapData.get("metadata").getString("author");
    }

    public String getMapVersion() {
        return this.mapData.get("metadata").getString("version");
    }

    public int getTileWidth() {
        return this.mapData.get("metadata").get("tilesets").getInt("tile_width");
    }

    public int getTileHeight() {
        return this.mapData.get("metadata").get("tilesets").getInt("tile_height");
    }

    public int getMapWidth() {
        return this.mapData.get("metadata").getInt("map_width");
    }

    public int getMapHeight() {
        return this.mapData.get("metadata").getInt("map_height");
    }

    public int getSpawnX() {
        return this.mapData.get("metadata").get("spawn_point").getInt("x");
    }

    public int getSpawnY() {
        return this.mapData.get("metadata").get("spawn_point").getInt("y");
    }

    public Music getBackgroundMusic() {
        String musicFile = this.mapData.get("metadata").getString("background_music");
        if (musicFile.equals("none") || musicFile.isEmpty() || musicFile.equals("continue")) {
            return null;
        }
        return Gdx.audio.newMusic(Gdx.files.internal(musicFile));
    }

    public String getBackgroundMusicFile() {
        return this.mapData.get("metadata").getString("background_music");
    }

    public String[] getTilesetRegionNames() {
        JsonValue tileset = this.mapData.get("tiles");
        Json json = new Json();
        return json.readValue(String[].class, tileset);
    }

    public int[] getCollisionTiles() {
        JsonValue collisionTiles = this.mapData.get("collision_tiles");
        Json json = new Json();
        return json.readValue(int[].class, collisionTiles);
    }

    public int[][] getMapMatrix() {
        JsonValue matrixData = this.mapData.get("map_matrix");
        Json json = new Json();
        return json.readValue(int[][].class, matrixData);
    }

    public String getTextureAtlasFile() {
        return this.mapData.get("metadata").getString("texture_atlas");
    }

    public JsonValue getObjectsLayer() {
        return this.mapData.get("metadata").get("map_objects");
    }

    public int getNumberOfMapEntities() {
        return this.mapData.get("metadata").getInt("map_entity_number");
    }

    private ExitConditions getExitConditions(JsonValue exitConditionsData) {
        Json json = new Json();
        String[] requiredItems = json.readValue(String[].class, exitConditionsData.get("inventory_items_required"));
        String[] requiredQuests = json.readValue(String[].class, exitConditionsData.get("quests_completed"));
        String[] npcsInteracted = json.readValue(String[].class, exitConditionsData.get("npcs_interacted"));
        int minTimeElapsed = exitConditionsData.getInt("min_time_elapsed");
        return new ExitConditions(requiredItems, requiredQuests, npcsInteracted, minTimeElapsed);
    }

    public ExitTile[] getExitPoints() {
        JsonValue exit_points = this.mapData.get("metadata").get("exit_points");
        ExitTile[] exitTiles = new ExitTile[exit_points.size];
        for (int j = 0; j < exit_points.size; ++j) {
            JsonValue exitPoint = exit_points.get(j);
            String targetMap = exitPoint.getString("target_map");
            int tileX = exitPoint.getInt("x");
            int tileY = exitPoint.getInt("y");
            int targetX = exitPoint.getInt("target_x");
            int targetY = exitPoint.getInt("target_y");
            ExitConditions conditions = this.getExitConditions(exitPoint.get("exit_conditions"));
            exitTiles[j] = new ExitTile(tileX, tileY, targetMap, targetX, targetY, conditions);
        }
        return exitTiles;
    }

    public Shader getMapShader() {
        JsonValue shaderData = this.mapData.get("shader");
        if (Objects.equals(shaderData.getString("name"), "default")) {
            return null;
        }
        FileHandle vertexFile = Gdx.files.internal(shaderData.getString("vertex"));
        FileHandle fragmentFile = Gdx.files.internal(shaderData.getString("fragment"));
        return new Shader(vertexFile, fragmentFile);
    }
}

