/*
 * Decompiled with CFR 0.152.
 */
package com.mathochist.mazegame.UI.Timer;

import com.badlogic.gdx.graphics.OrthographicCamera;
import com.badlogic.gdx.graphics.g2d.Batch;
import com.badlogic.gdx.graphics.g2d.BitmapFont;
import com.badlogic.gdx.graphics.g2d.SpriteBatch;
import com.mathochist.mazegame.UI.Timer.TimerPenalty;
import java.util.ArrayList;

public class TimerManager {
    public static double START_TIME = 0.0;
    public static final double TIME_LIMIT = 300.0;
    private final ArrayList<TimerPenalty> penalties = new ArrayList();

    public void startTimer() {
        START_TIME = System.currentTimeMillis();
    }

    public double getTimeLeft() {
        double timeElapsed = ((double)System.currentTimeMillis() - START_TIME) / 1000.0;
        return 300.0 - timeElapsed;
    }

    public boolean isTimeUp() {
        return this.getTimeLeft() <= 0.0;
    }

    public void addPenalty(double seconds) {
        START_TIME -= seconds * 1000.0;
        this.penalties.add(new TimerPenalty(seconds, System.currentTimeMillis()));
    }

    public void resetTimer() {
        START_TIME = 0.0;
        this.penalties.clear();
    }

    public void renderToHUD(BitmapFont font, SpriteBatch batch, OrthographicCamera camera) {
        double timeLeft = this.getTimeLeft();
        double minutesLeft = Math.floor(timeLeft / 60.0);
        double secondsLeft = Math.floor(timeLeft % 60.0);
        font.draw((Batch)batch, "Time: " + (int)minutesLeft + ":" + String.format("%02d", (int)secondsLeft), camera.viewportWidth - 120.0f, camera.viewportHeight - 2.0f);
        font.setColor(255.0f, 0.0f, 0.0f, 1.0f);
        float penaltyY = camera.viewportHeight - 30.0f;
        long currentTime = System.currentTimeMillis();
        ArrayList<TimerPenalty> expiredPenalties = new ArrayList<TimerPenalty>();
        for (TimerPenalty penalty : this.penalties) {
            double timeSinceAdded = ((double)currentTime - penalty.timeAdded()) / 1000.0;
            if (timeSinceAdded <= 3.0) {
                font.draw((Batch)batch, "-" + (int)penalty.penaltySeconds() + "s", camera.viewportWidth - 120.0f, penaltyY);
                penaltyY -= 25.0f;
                continue;
            }
            expiredPenalties.add(penalty);
        }
        font.setColor(1.0f, 1.0f, 1.0f, 1.0f);
        this.penalties.removeAll(expiredPenalties);
    }
}

