/*
 * Decompiled with CFR 0.152.
 */
package com.mathochist.mazegame.UI.Speech;

import com.badlogic.gdx.graphics.OrthographicCamera;
import com.badlogic.gdx.graphics.g2d.BitmapFont;
import com.badlogic.gdx.graphics.g2d.SpriteBatch;
import com.mathochist.mazegame.UI.Speech.SpeechBubble;
import com.mathochist.mazegame.UI.Speech.SpeechType;
import java.util.ArrayList;

public class SpeechBubbleManager {
    private SpriteBatch hudBatch;
    private OrthographicCamera hudCamera;
    private BitmapFont main_font;
    private ArrayList<SpeechBubble> bubbles;

    public SpeechBubbleManager(SpriteBatch hudBatch, OrthographicCamera hudCamera, BitmapFont main_font) {
        this.main_font = main_font;
        this.hudCamera = hudCamera;
        this.hudBatch = hudBatch;
        this.bubbles = new ArrayList();
    }

    public void render() {
        ArrayList<SpeechBubble> bubblesToRemove = new ArrayList<SpeechBubble>();
        for (SpeechBubble bubble : this.bubbles) {
            bubble.render();
            if (!bubble.isExpired()) continue;
            bubble.dispose();
            bubblesToRemove.add(bubble);
        }
        this.bubbles.removeAll(bubblesToRemove);
    }

    public void createSpeechBubble(SpeechBubble bubble) {
        bubble.setStartTime(System.currentTimeMillis());
        this.bubbles.add(bubble);
    }

    public void createSpeechBubble(SpeechType type, String message, int durationMs) {
        SpeechBubble bubble = new SpeechBubble(type, message, durationMs, this.hudBatch, this.hudCamera, this.main_font);
        bubble.setStartTime(System.currentTimeMillis());
        this.bubbles.add(bubble);
    }

    public void createSpeechBubble(SpeechType type, String message, int durationMs, BitmapFont font) {
        SpeechBubble bubble = new SpeechBubble(type, message, durationMs, this.hudBatch, this.hudCamera, font);
        bubble.setStartTime(System.currentTimeMillis());
        this.bubbles.add(bubble);
    }

    public void dispose() {
        for (SpeechBubble bubble : this.bubbles) {
            bubble.dispose();
        }
        this.bubbles.clear();
    }

    public void removeBubblesOfType(SpeechType type) {
        ArrayList<SpeechBubble> bubblesToRemove = new ArrayList<SpeechBubble>();
        for (SpeechBubble bubble : this.bubbles) {
            if (bubble.getType() != type) continue;
            bubble.dispose();
            bubblesToRemove.add(bubble);
        }
        this.bubbles.removeAll(bubblesToRemove);
    }

    public SpriteBatch getHudBatch() {
        return this.hudBatch;
    }

    public OrthographicCamera getHudCamera() {
        return this.hudCamera;
    }

    public BitmapFont getMainFont() {
        return this.main_font;
    }

    public void clear() {
        for (SpeechBubble bubble : this.bubbles) {
            bubble.dispose();
        }
        this.bubbles.clear();
    }
}

