/*
 * Decompiled with CFR 0.152.
 */
package com.mathochist.mazegame.UI.Speech;

import com.badlogic.gdx.graphics.OrthographicCamera;
import com.badlogic.gdx.graphics.g2d.Batch;
import com.badlogic.gdx.graphics.g2d.BitmapFont;
import com.badlogic.gdx.graphics.g2d.GlyphLayout;
import com.badlogic.gdx.graphics.g2d.SpriteBatch;
import com.badlogic.gdx.graphics.glutils.ShapeRenderer;
import com.mathochist.mazegame.UI.Speech.SpeechType;

public class SpeechBubble {
    private SpeechType type;
    private String message;
    private int durationMs;
    private SpriteBatch hudBatch;
    private OrthographicCamera camera;
    private BitmapFont font;
    private ShapeRenderer shapeRenderer;
    private double startTime;

    public SpeechBubble(SpeechType type, String message, int durationMs, SpriteBatch hudBatch, OrthographicCamera camera, BitmapFont font) {
        this.type = type;
        this.message = message;
        this.durationMs = durationMs;
        this.hudBatch = hudBatch;
        this.camera = camera;
        this.font = font;
        this.shapeRenderer = new ShapeRenderer();
    }

    private void render_npc_bubble() {
        GlyphLayout layout = new GlyphLayout(this.font, this.message);
        float padding = 40.0f;
        float bubble_width = layout.width + padding * 2.0f;
        float bubble_height = layout.height + padding * 2.0f;
        float bubble_x = (this.camera.viewportWidth - bubble_width) / 2.0f;
        float bubble_y = this.camera.viewportHeight - bubble_height - 40.0f;
        this.shapeRenderer.setProjectionMatrix(this.camera.combined);
        this.shapeRenderer.begin(ShapeRenderer.ShapeType.Filled);
        this.shapeRenderer.setColor(0.0f, 0.0f, 0.0f, 0.8f);
        this.shapeRenderer.rect(bubble_x, bubble_y, bubble_width, bubble_height);
        this.shapeRenderer.end();
        this.hudBatch.begin();
        this.font.draw((Batch)this.hudBatch, this.message, bubble_x + padding, bubble_y + bubble_height - padding);
        this.hudBatch.end();
        this.shapeRenderer.setProjectionMatrix(this.camera.combined);
        this.shapeRenderer.begin(ShapeRenderer.ShapeType.Filled);
        this.shapeRenderer.setColor(1.0f, 1.0f, 1.0f, 1.0f);
        float arrow_x = this.camera.viewportWidth / 2.0f;
        float arrow_y = (float)((double)bubble_y + 5.0 * Math.sin((double)System.currentTimeMillis() / 200.0));
        this.shapeRenderer.triangle(arrow_x - 15.0f, arrow_y + 15.0f, arrow_x + 15.0f, arrow_y + 15.0f, arrow_x, arrow_y);
        this.shapeRenderer.end();
    }

    private void pass() {
    }

    public void render() {
        switch (this.type) {
            case NPC_SPEECH: {
                this.render_npc_bubble();
                break;
            }
            default: {
                this.pass();
            }
        }
    }

    public SpeechType getType() {
        return this.type;
    }

    public String getMessage() {
        return this.message;
    }

    public int getDurationMs() {
        return this.durationMs;
    }

    public SpriteBatch getHudBatch() {
        return this.hudBatch;
    }

    public BitmapFont getFont() {
        return this.font;
    }

    public OrthographicCamera getCamera() {
        return this.camera;
    }

    public void setStartTime(double startTime) {
        this.startTime = startTime;
    }

    public boolean isExpired() {
        return (double)System.currentTimeMillis() - this.startTime >= (double)this.durationMs;
    }

    public void dispose() {
        this.shapeRenderer.dispose();
    }
}

