/*
 * Decompiled with CFR 0.152.
 */
package com.mathochist.mazegame.UI;

import com.badlogic.gdx.Gdx;
import com.badlogic.gdx.graphics.OrthographicCamera;
import com.badlogic.gdx.graphics.g2d.Batch;
import com.badlogic.gdx.graphics.g2d.BitmapFont;
import com.badlogic.gdx.graphics.g2d.SpriteBatch;
import com.badlogic.gdx.graphics.g2d.TextureAtlas;
import com.mathochist.mazegame.Main;
import com.mathochist.mazegame.UI.Speech.SpeechBubbleManager;

public class Hud {
    private Main game;
    private OrthographicCamera hudCamera;
    private SpriteBatch hudBatch;
    private BitmapFont small_font;
    private BitmapFont main_font;
    private BitmapFont vlarge_font;
    private TextureAtlas gameUIAtlas;
    private SpeechBubbleManager speechBubbleManager;

    public Hud(Main game) {
        this.game = game;
        this.hudBatch = new SpriteBatch();
        this.hudCamera = new OrthographicCamera(game.WIDTH, game.HEIGHT);
        this.hudCamera.position.set((float)game.WIDTH / 2.0f, (float)game.HEIGHT / 2.0f, 1.0f);
        this.small_font = new BitmapFont(Gdx.files.internal("fonts/game_font.fnt"), Gdx.files.internal("fonts/game_font.png"), false);
        this.small_font.getData().setScale(0.5f);
        this.main_font = new BitmapFont(Gdx.files.internal("fonts/game_font.fnt"), Gdx.files.internal("fonts/game_font.png"), false);
        this.main_font.getData().setScale(1.0f);
        this.vlarge_font = new BitmapFont(Gdx.files.internal("fonts/vlarge_game_font.fnt"));
        this.speechBubbleManager = new SpeechBubbleManager(this.hudBatch, this.hudCamera, this.main_font);
        this.gameUIAtlas = new TextureAtlas(Gdx.files.internal("game_ui/game_ui.atlas"));
    }

    public SpriteBatch getHudBatch() {
        return this.hudBatch;
    }

    public OrthographicCamera getHudCamera() {
        return this.hudCamera;
    }

    public void dispose() {
        this.small_font.dispose();
        this.main_font.dispose();
        this.speechBubbleManager.dispose();
    }

    public void render(float delta) {
        this.hudCamera.update();
        this.hudBatch.setProjectionMatrix(this.hudCamera.combined);
        this.hudBatch.begin();
        this.small_font.draw((Batch)this.hudBatch, "FPS: " + Gdx.graphics.getFramesPerSecond(), 2.0f, this.hudCamera.viewportHeight - 2.0f);
        this.game.getTimerManager().renderToHUD(this.main_font, this.hudBatch, this.hudCamera);
        this.game.getPlayerInventory().render(this.hudBatch, this.hudCamera, this.gameUIAtlas);
        this.game.getEventsCounter().renderEventsCounterToHUD(this.hudBatch, this.hudCamera, this.small_font);
        this.hudBatch.end();
        this.speechBubbleManager.render();
    }

    public SpeechBubbleManager getSpeechBubbleManager() {
        return this.speechBubbleManager;
    }

    public void renderPauseScreen() {
        this.hudCamera.update();
        this.hudBatch.setProjectionMatrix(this.hudCamera.combined);
        this.hudBatch.begin();
        float centerX = this.hudCamera.viewportWidth / 2.0f;
        float centerY = this.hudCamera.viewportHeight / 2.0f;
        this.vlarge_font.draw((Batch)this.hudBatch, "Game Paused", centerX - 350.0f, centerY + 100.0f);
        this.main_font.draw((Batch)this.hudBatch, "Press ESC to Resume", centerX - 140.0f, centerY - 10.0f);
        this.hudBatch.end();
    }
}

