/*
 * Decompiled with CFR 0.152.
 */
package com.mathochist.mazegame.UI;

import com.badlogic.gdx.graphics.OrthographicCamera;
import com.badlogic.gdx.graphics.g2d.Batch;
import com.badlogic.gdx.graphics.g2d.BitmapFont;
import com.badlogic.gdx.graphics.g2d.SpriteBatch;

public class EventsCounter {
    private int positiveEvents = 0;
    private int negativeEvents = 0;
    private int hiddenEvents = 0;
    private boolean librarySprintEventTriggered = false;
    private boolean foundKeycardEventTriggered;
    private boolean vendingMachineEventTriggered;
    private boolean fallenIntoBasementEventTriggered;

    public void librarySprintEvent() {
        if (this.librarySprintEventTriggered) {
            return;
        }
        ++this.hiddenEvents;
        this.librarySprintEventTriggered = true;
    }

    public void foundKeycardEvent() {
        if (this.foundKeycardEventTriggered) {
            return;
        }
        ++this.negativeEvents;
        this.foundKeycardEventTriggered = true;
    }

    public void vendingMachineEvent() {
        if (this.vendingMachineEventTriggered) {
            return;
        }
        ++this.positiveEvents;
        this.vendingMachineEventTriggered = true;
    }

    public void fallenIntoBasementEvent() {
        if (this.fallenIntoBasementEventTriggered) {
            return;
        }
        ++this.hiddenEvents;
        this.fallenIntoBasementEventTriggered = true;
    }

    public void renderEventsCounterToHUD(SpriteBatch hudBatch, OrthographicCamera camera, BitmapFont font) {
        font.draw((Batch)hudBatch, "Positive Events: " + this.positiveEvents, 2.0f, camera.viewportHeight - 15.0f);
        font.draw((Batch)hudBatch, "Negative Events: " + this.negativeEvents, 2.0f, camera.viewportHeight - 30.0f);
        font.draw((Batch)hudBatch, "Hidden Events: " + this.hiddenEvents, 2.0f, camera.viewportHeight - 45.0f);
    }
}

