/*
 * Decompiled with CFR 0.152.
 */
package com.mathochist.mazegame.Screens;

import com.badlogic.gdx.Gdx;
import com.badlogic.gdx.audio.Music;
import com.badlogic.gdx.graphics.g2d.SpriteBatch;
import com.badlogic.gdx.graphics.g2d.TextureRegion;
import com.badlogic.gdx.scenes.scene2d.Actor;
import com.badlogic.gdx.scenes.scene2d.Stage;
import com.badlogic.gdx.scenes.scene2d.ui.Button;
import com.badlogic.gdx.scenes.scene2d.ui.Label;
import com.badlogic.gdx.scenes.scene2d.ui.Table;
import com.badlogic.gdx.scenes.scene2d.utils.ChangeListener;
import com.badlogic.gdx.utils.viewport.FitViewport;
import com.mathochist.mazegame.Main;
import com.mathochist.mazegame.Screens.DefaultScreen;
import com.mathochist.mazegame.Screens.IntroScreen;
import com.mathochist.mazegame.UI.ButtonHoverListener;
import com.mathochist.mazegame.UI.MainMenuUISkin;

public class TitleScreen
extends DefaultScreen {
    private Stage stage;
    private Table table;
    private SpriteBatch batch;
    private TextureRegion backgroundTexture;
    private MainMenuUISkin uiSkin;

    public TitleScreen(Main game) {
        super(game);
    }

    @Override
    public void show() {
        final Music backgroundMusic = Gdx.audio.newMusic(Gdx.files.internal("audio/title_screen.mp3"));
        backgroundMusic.setLooping(true);
        backgroundMusic.setVolume(0.5f);
        backgroundMusic.play();
        this.stage = new Stage(new FitViewport(Gdx.graphics.getWidth(), Gdx.graphics.getHeight()));
        Gdx.input.setInputProcessor(this.stage);
        this.table = new Table();
        this.table.setFillParent(true);
        this.stage.addActor(this.table);
        Table buttonTable = new Table();
        this.table.addActor(buttonTable);
        Table titleTable = new Table();
        this.table.addActor(titleTable);
        this.uiSkin = new MainMenuUISkin();
        this.batch = new SpriteBatch();
        Label presentsLabel = new Label("Mathochist Studios Presents", this.uiSkin.getSkin(), "presents_grey");
        titleTable.add(presentsLabel).expand().padBottom(10.0f);
        titleTable.row();
        Label titleLabel = new Label((CharSequence)"All Nighter", this.uiSkin.getSkin());
        titleTable.add(titleLabel).expand();
        Button startButton = new Button(this.uiSkin.getSkin(), "start_button");
        buttonTable.add(startButton).expand().width(95.0f).height(33.333f).padBottom(5.0f).align(8);
        startButton.addListener(new ChangeListener(this){
            final /* synthetic */ TitleScreen this$0;
            {
                this.this$0 = this$0;
            }

            @Override
            public void changed(ChangeListener.ChangeEvent changeEvent, Actor actor) {
                this.this$0.game.setScreen(new IntroScreen(this.this$0.game, backgroundMusic));
            }
        });
        buttonTable.row();
        Button settingsButton = new Button(this.uiSkin.getSkin(), "settings_button");
        buttonTable.add(settingsButton).expand().width(126.666f).height(33.333f).padBottom(5.0f).align(8);
        settingsButton.addListener(new ChangeListener(){

            @Override
            public void changed(ChangeListener.ChangeEvent changeEvent, Actor actor) {
                Gdx.app.log("TitleScreen", "Settings button clicked - transition to SettingsScreen");
            }
        });
        buttonTable.row();
        Button creditsButton = new Button(this.uiSkin.getSkin(), "credits_button");
        buttonTable.add(creditsButton).expand().width(115.0f).height(33.333f).padBottom(5.0f).align(8);
        creditsButton.addListener(new ChangeListener(){

            @Override
            public void changed(ChangeListener.ChangeEvent changeEvent, Actor actor) {
                Gdx.app.log("TitleScreen", "Credits button clicked - transition to CreditsScreen");
            }
        });
        buttonTable.row();
        Button exitButton = new Button(this.uiSkin.getSkin(), "exit_button");
        buttonTable.add(exitButton).expand().width(76.666f).height(33.333f).padBottom(5.0f).align(8);
        exitButton.addListener(new ChangeListener(){

            @Override
            public void changed(ChangeListener.ChangeEvent changeEvent, Actor actor) {
                Gdx.app.exit();
            }
        });
        startButton.addListener(new ButtonHoverListener());
        settingsButton.addListener(new ButtonHoverListener());
        creditsButton.addListener(new ButtonHoverListener());
        exitButton.addListener(new ButtonHoverListener());
        buttonTable.left().padRight(300.0f);
        buttonTable.bottom();
        this.table.add(titleTable).expand().padTop(100.0f);
        this.table.row();
        this.table.add(buttonTable).expand().padBottom(150.0f);
        this.table.row();
        this.table.setDebug(false);
    }

    @Override
    public void render(float delta) {
        Gdx.gl.glClearColor(0.0f, 0.0f, 0.0f, 1.0f);
        Gdx.gl.glClear(16384);
        this.batch.begin();
        this.batch.end();
        this.stage.act(delta);
        this.stage.draw();
    }

    @Override
    public void resize(int width, int height) {
        this.stage.getViewport().update(width, height, true);
    }

    @Override
    public void dispose() {
        this.stage.dispose();
        this.uiSkin.dispose();
        this.batch.dispose();
    }

    public Table getTable() {
        return this.table;
    }

    public Stage getStage() {
        return this.stage;
    }

    @Override
    public boolean keyDown(int keycode) {
        return false;
    }

    @Override
    public boolean keyUp(int keycode) {
        return false;
    }
}

