/*
 * Decompiled with CFR 0.152.
 */
package com.mathochist.mazegame.Screens;

import com.badlogic.gdx.Gdx;
import com.badlogic.gdx.audio.Music;
import com.badlogic.gdx.graphics.Cursor;
import com.badlogic.gdx.graphics.Texture;
import com.badlogic.gdx.graphics.g2d.SpriteBatch;
import com.badlogic.gdx.graphics.g2d.TextureRegion;
import com.badlogic.gdx.scenes.scene2d.Stage;
import com.badlogic.gdx.scenes.scene2d.ui.Label;
import com.badlogic.gdx.scenes.scene2d.ui.Table;
import com.badlogic.gdx.utils.viewport.FitViewport;
import com.mathochist.mazegame.Main;
import com.mathochist.mazegame.Screens.DefaultScreen;
import com.mathochist.mazegame.Screens.Game.LibraryScreen;
import com.mathochist.mazegame.UI.MainMenuUISkin;

public class IntroScreen
extends DefaultScreen {
    private Stage stage;
    private Table table;
    private SpriteBatch batch;
    private MainMenuUISkin uiSkin;
    private Music backgroundMusic;
    private Texture keyBindsTexture;

    public IntroScreen(Main game, Music backgroundMusic) {
        super(game);
        Gdx.graphics.setSystemCursor(Cursor.SystemCursor.Arrow);
        this.backgroundMusic = backgroundMusic;
    }

    @Override
    public void show() {
        this.stage = new Stage(new FitViewport(Gdx.graphics.getWidth(), Gdx.graphics.getHeight()));
        Gdx.input.setInputProcessor(this.stage);
        this.table = new Table();
        this.table.setFillParent(true);
        this.stage.addActor(this.table);
        this.uiSkin = new MainMenuUISkin();
        this.batch = new SpriteBatch();
        Table textTable = new Table();
        this.table.addActor(textTable);
        Table escapeTable = new Table();
        this.table.addActor(escapeTable);
        Label settingSceneLabel = new Label("You are studying in the Morrell Library after closing hours not during exam season, and the dean sees you!", this.uiSkin.getSkin(), "game_font");
        textTable.add(settingSceneLabel).padBottom(10.0f);
        textTable.row();
        Label instructionLabel = new Label("Find your lost keycard and get out before you get caught!", this.uiSkin.getSkin(), "game_font");
        textTable.add(instructionLabel).padBottom(10.0f);
        textTable.row();
        Label timeLabel = new Label("You have 5 minutes to escape the uni!", this.uiSkin.getSkin(), "game_font");
        textTable.add(timeLabel).padBottom(10.0f);
        textTable.row();
        this.keyBindsTexture = new Texture(Gdx.files.internal("MainMenu/KeyBinds.png"));
        Label skipLabel = new Label("Press Any Button to continue..", this.uiSkin.getSkin(), "game_font");
        escapeTable.add(skipLabel).expand().bottom().right().pad(10.0f);
        escapeTable.row();
        this.table.add(textTable).expand();
        this.table.row();
        this.table.add(escapeTable).expand().bottom().right().pad(10.0f);
    }

    @Override
    public void render(float delta) {
        Gdx.gl.glClearColor(0.0f, 0.0f, 0.0f, 1.0f);
        Gdx.gl.glClear(16384);
        this.batch.begin();
        this.batch.draw(new TextureRegion(this.keyBindsTexture), (float)Gdx.graphics.getWidth() / 2.0f - 300.0f, (float)Gdx.graphics.getHeight() / 2.0f - 150.0f, 600.0f, 200.0f);
        this.batch.end();
        this.stage.act(delta);
        this.stage.draw();
        if (Gdx.input.isKeyJustPressed(-1)) {
            this.backgroundMusic.dispose();
            this.game.getTimerManager().startTimer();
            this.game.setScreen(new LibraryScreen(this.game));
        }
    }

    @Override
    public void resize(int width, int height) {
        this.stage.getViewport().update(width, height, true);
    }

    @Override
    public void dispose() {
        this.stage.dispose();
        this.uiSkin.dispose();
        this.batch.dispose();
    }

    @Override
    public boolean keyDown(int keycode) {
        return false;
    }

    @Override
    public boolean keyUp(int keycode) {
        return false;
    }
}

