/*
 * Decompiled with CFR 0.152.
 */
package com.mathochist.mazegame.Screens.Game;

import com.badlogic.gdx.Gdx;
import com.mathochist.mazegame.Entities.Player;
import com.mathochist.mazegame.Main;
import com.mathochist.mazegame.Rendering.RenderObject;
import com.mathochist.mazegame.Screens.EndScreen;
import com.mathochist.mazegame.Screens.Game.BaseGameScreen;
import com.mathochist.mazegame.UI.Speech.SpeechType;
import com.mathochist.mazegame.UI.Timer.TimerManager;
import com.mathochist.mazegame.World.GameWorld;

public class LibraryScreen3
extends BaseGameScreen {
    private double timeSinceLastSprintPenalty = 0.0;
    private double timeSinceLastPauseToggle = 0.0;

    public LibraryScreen3(Main game) {
        super(game);
        super.setWorld(new GameWorld(game, this, Gdx.files.internal("maps/library3.json"), super.getScreenBatch()));
        super.resize(Gdx.graphics.getWidth(), Gdx.graphics.getHeight());
        super.getWorld().tileDrawYOffset -= Gdx.graphics.getHeight() - game.HEIGHT;
        int[] spawnPoint = super.getWorld().getSpawnPointPixels();
        super.getCamera().position.set(spawnPoint[0], spawnPoint[1], 0.0f);
        super.getCamera().update();
        super.setPlayer(new Player(game, super.getCamera(), super.getScreenBatch(), super.getWorld(), spawnPoint[0], spawnPoint[1]));
    }

    public LibraryScreen3(Main game, Float spawnX, Float spawnY) {
        super(game);
        super.setWorld(new GameWorld(game, this, Gdx.files.internal("maps/library3.json"), super.getScreenBatch()));
        super.resize(Gdx.graphics.getWidth(), Gdx.graphics.getHeight());
        super.getWorld().tileDrawYOffset -= Gdx.graphics.getHeight() - game.HEIGHT;
        float[] spawnPixels = super.getWorld().getPixels(spawnX.floatValue(), spawnY.floatValue());
        super.getCamera().position.set(spawnPixels[0], spawnPixels[1], 0.0f);
        super.getCamera().update();
        super.setPlayer(new Player(game, super.getCamera(), super.getScreenBatch(), super.getWorld(), spawnPixels[0], spawnPixels[1]));
    }

    @Override
    public void show() {
    }

    @Override
    public void render(float delta) {
        if (this.isPrepareTransition()) {
            return;
        }
        if ((double)System.currentTimeMillis() - this.timeSinceLastPauseToggle >= 300.0 && Gdx.input.isKeyJustPressed(111)) {
            this.setPaused(!this.isPaused());
            this.timeSinceLastPauseToggle = System.currentTimeMillis();
        }
        if (super.isPaused()) {
            super.getGameHud().renderPauseScreen();
            TimerManager.START_TIME += (double)(delta * 1000.0f);
            return;
        }
        Gdx.gl.glClearColor(0.0f, 0.0f, 0.0f, 1.0f);
        Gdx.gl.glClear(16384);
        super.getCamera().update();
        super.getScreenBatch().setProjectionMatrix(super.getCamera().combined);
        super.getWorld().render(super.getViewport(), super.getRenderBuffer());
        super.getPlayer().update(delta, super.getRenderBuffer());
        for (RenderObject obj : super.getRenderBuffer().getBufferOrderedByZIndex()) {
            obj.render();
        }
        super.getRenderBuffer().clearBuffer();
        super.getWorld().renderDebugLayer();
        super.getGameHud().render(delta);
        if (super.getPlayer().isSprinting()) {
            super.getGameHud().getSpeechBubbleManager().removeBubblesOfType(SpeechType.NPC_SPEECH);
            super.getGameHud().getSpeechBubbleManager().createSpeechBubble(SpeechType.NPC_SPEECH, "Librarian: Oi, stop running!", 1000);
            if (this.timeSinceLastSprintPenalty == 0.0 || (double)System.currentTimeMillis() - this.timeSinceLastSprintPenalty >= 1000.0) {
                this.game.getTimerManager().addPenalty(5.0);
                this.timeSinceLastSprintPenalty = System.currentTimeMillis();
            }
            this.game.getEventsCounter().librarySprintEvent();
        }
        if (this.game.getTimerManager().isTimeUp()) {
            super.getWorld().getBackgroundMusic().stop();
            this.game.setScreen(new EndScreen(this.game));
        }
    }

    @Override
    public void dispose() {
        super.getGameHud().dispose();
        super.getWorld().dispose();
        super.getPlayer().dispose();
    }
}

