/*
 * Decompiled with CFR 0.152.
 */
package com.mathochist.mazegame.Screens.Game;

import com.badlogic.gdx.Gdx;
import com.mathochist.mazegame.Entities.Player;
import com.mathochist.mazegame.Entities.PlayerInventory.InventoryObject;
import com.mathochist.mazegame.Main;
import com.mathochist.mazegame.Rendering.RenderObject;
import com.mathochist.mazegame.Screens.EndScreen;
import com.mathochist.mazegame.Screens.Game.BaseGameScreen;
import com.mathochist.mazegame.UI.Speech.SpeechType;
import com.mathochist.mazegame.UI.Timer.TimerManager;
import com.mathochist.mazegame.World.GameWorld;

public class LibraryBasementScreen
extends BaseGameScreen {
    private double timeSinceLastPauseToggle = 0.0;

    public LibraryBasementScreen(Main game) {
        super(game);
        super.setWorld(new GameWorld(game, this, Gdx.files.internal("maps/library_basement.json"), super.getScreenBatch()));
        super.resize(Gdx.graphics.getWidth(), Gdx.graphics.getHeight());
        super.getWorld().tileDrawYOffset -= Gdx.graphics.getHeight() - game.HEIGHT;
        int[] spawnPoint = super.getWorld().getSpawnPointPixels();
        super.getCamera().position.set(spawnPoint[0], spawnPoint[1], 0.0f);
        super.getCamera().update();
        super.setPlayer(new Player(game, super.getCamera(), super.getScreenBatch(), super.getWorld(), spawnPoint[0], spawnPoint[1]));
        game.getEventsCounter().fallenIntoBasementEvent();
    }

    public LibraryBasementScreen(Main game, Float spawnX, Float spawnY) {
        super(game);
        super.setWorld(new GameWorld(game, this, Gdx.files.internal("maps/library_basement.json"), super.getScreenBatch()));
        super.resize(Gdx.graphics.getWidth(), Gdx.graphics.getHeight());
        super.getWorld().tileDrawYOffset -= Gdx.graphics.getHeight() - game.HEIGHT;
        float[] spawnPixels = super.getWorld().getPixels(spawnX.floatValue(), spawnY.floatValue());
        super.getCamera().position.set(spawnPixels[0], spawnPixels[1], 0.0f);
        super.getCamera().update();
        super.setPlayer(new Player(game, super.getCamera(), super.getScreenBatch(), super.getWorld(), spawnPixels[0], spawnPixels[1]));
        if (!game.getPlayerInventory().hasItem(InventoryObject.BASEMENT_KEY)) {
            super.getGameHud().getSpeechBubbleManager().createSpeechBubble(SpeechType.NPC_SPEECH, "The floor collapses underneath you and you fall into the basement, find the key to escape!", 3000);
        }
        game.getEventsCounter().fallenIntoBasementEvent();
    }

    @Override
    public void show() {
    }

    @Override
    public void render(float delta) {
        if ((double)System.currentTimeMillis() - this.timeSinceLastPauseToggle >= 300.0 && Gdx.input.isKeyJustPressed(111)) {
            this.setPaused(!this.isPaused());
            this.timeSinceLastPauseToggle = System.currentTimeMillis();
        }
        if (super.isPaused()) {
            super.getGameHud().renderPauseScreen();
            TimerManager.START_TIME += (double)(delta * 1000.0f);
            return;
        }
        Gdx.gl.glClearColor(0.0f, 0.0f, 0.0f, 1.0f);
        Gdx.gl.glClear(16384);
        super.getCamera().update();
        super.getScreenBatch().setProjectionMatrix(super.getCamera().combined);
        super.getWorld().render(super.getViewport(), super.getRenderBuffer());
        super.getPlayer().update(delta, super.getRenderBuffer());
        for (RenderObject obj : super.getRenderBuffer().getBufferOrderedByZIndex()) {
            obj.render();
        }
        super.getRenderBuffer().clearBuffer();
        super.getWorld().renderDebugLayer();
        super.getGameHud().render(delta);
        if (this.game.getTimerManager().isTimeUp()) {
            super.getWorld().getBackgroundMusic().stop();
            this.game.setScreen(new EndScreen(this.game));
        }
    }

    @Override
    public void dispose() {
        super.getGameHud().dispose();
        super.getWorld().dispose();
        super.getPlayer().dispose();
    }
}

