/*
 * Decompiled with CFR 0.152.
 */
package com.mathochist.mazegame.Screens.Game;

import com.badlogic.gdx.Gdx;
import com.badlogic.gdx.graphics.Cursor;
import com.badlogic.gdx.graphics.OrthographicCamera;
import com.badlogic.gdx.graphics.g2d.SpriteBatch;
import com.badlogic.gdx.utils.viewport.FitViewport;
import com.mathochist.mazegame.Entities.Player;
import com.mathochist.mazegame.Main;
import com.mathochist.mazegame.Rendering.RenderBuffer;
import com.mathochist.mazegame.Screens.DefaultScreen;
import com.mathochist.mazegame.UI.Hud;
import com.mathochist.mazegame.World.GameWorld;

public abstract class BaseGameScreen
extends DefaultScreen {
    private OrthographicCamera camera;
    private FitViewport viewport;
    private Hud gameHud;
    private float VIEWPORT_WIDTH = 0.0f;
    private float VIEWPORT_HEIGHT = 0.0f;
    private Player player;
    private SpriteBatch screenBatch;
    private GameWorld world;
    private RenderBuffer renderBuffer;
    private boolean isPaused = false;
    private boolean prepareTransition = false;

    public BaseGameScreen(Main game) {
        super(game);
        Gdx.graphics.setSystemCursor(Cursor.SystemCursor.Arrow);
        Gdx.input.setInputProcessor(this);
        this.VIEWPORT_WIDTH = game.WIDTH;
        this.VIEWPORT_HEIGHT = game.HEIGHT;
        this.gameHud = new Hud(game);
        this.camera = new OrthographicCamera(this.VIEWPORT_WIDTH, this.VIEWPORT_HEIGHT);
        this.camera.position.set(this.VIEWPORT_WIDTH / 2.0f, this.VIEWPORT_HEIGHT / 2.0f, 0.0f);
        this.camera.update();
        this.viewport = new FitViewport(this.VIEWPORT_WIDTH, this.VIEWPORT_HEIGHT, this.camera);
        this.screenBatch = new SpriteBatch();
        this.renderBuffer = new RenderBuffer();
    }

    public BaseGameScreen(Main game, Float spawnX, Float spawnY) {
        super(game);
        Gdx.graphics.setSystemCursor(Cursor.SystemCursor.Arrow);
        Gdx.input.setInputProcessor(this);
        this.VIEWPORT_WIDTH = game.WIDTH;
        this.VIEWPORT_HEIGHT = game.HEIGHT;
        this.gameHud = new Hud(game);
        this.camera = new OrthographicCamera(this.VIEWPORT_WIDTH, this.VIEWPORT_HEIGHT);
        this.camera.position.set(this.VIEWPORT_WIDTH / 2.0f, this.VIEWPORT_HEIGHT / 2.0f, 0.0f);
        this.camera.update();
        this.viewport = new FitViewport(this.VIEWPORT_WIDTH, this.VIEWPORT_HEIGHT, this.camera);
        this.screenBatch = new SpriteBatch();
        this.renderBuffer = new RenderBuffer();
    }

    public Player getPlayer() {
        return this.player;
    }

    public void setPlayer(Player player) {
        this.player = player;
    }

    @Override
    public abstract void show();

    @Override
    public abstract void render(float var1);

    @Override
    public void resize(int width, int height) {
        this.viewport.update(width, height);
        this.world.scaleWorld(this.VIEWPORT_HEIGHT, height);
    }

    @Override
    public abstract void dispose();

    public OrthographicCamera getCamera() {
        return this.camera;
    }

    public Hud getGameHud() {
        return this.gameHud;
    }

    @Override
    public boolean keyDown(int keycode) {
        this.player.getKeyBuffer().addKeyPressed(keycode);
        return true;
    }

    @Override
    public boolean keyUp(int keycode) {
        this.player.getKeyBuffer().removeKeyPressed(keycode);
        return true;
    }

    public SpriteBatch getScreenBatch() {
        return this.screenBatch;
    }

    public void setWorld(GameWorld world) {
        this.world = world;
        this.resize((int)this.VIEWPORT_WIDTH, (int)this.VIEWPORT_HEIGHT);
    }

    public GameWorld getWorld() {
        return this.world;
    }

    public FitViewport getViewport() {
        return this.viewport;
    }

    public RenderBuffer getRenderBuffer() {
        return this.renderBuffer;
    }

    public boolean isPaused() {
        return this.isPaused;
    }

    public void setPaused(boolean paused) {
        this.isPaused = paused;
    }

    public boolean isPrepareTransition() {
        return this.prepareTransition;
    }

    public void setPrepareTransition(boolean prepareTransition) {
        this.prepareTransition = prepareTransition;
    }
}

