/*
 * Decompiled with CFR 0.152.
 */
package com.mathochist.mazegame.Screens;

import com.badlogic.gdx.Gdx;
import com.badlogic.gdx.audio.Music;
import com.badlogic.gdx.graphics.g2d.SpriteBatch;
import com.badlogic.gdx.scenes.scene2d.Actor;
import com.badlogic.gdx.scenes.scene2d.Stage;
import com.badlogic.gdx.scenes.scene2d.ui.Button;
import com.badlogic.gdx.scenes.scene2d.ui.Label;
import com.badlogic.gdx.scenes.scene2d.ui.Table;
import com.badlogic.gdx.scenes.scene2d.utils.ChangeListener;
import com.badlogic.gdx.utils.viewport.FitViewport;
import com.mathochist.mazegame.Main;
import com.mathochist.mazegame.Screens.DefaultScreen;
import com.mathochist.mazegame.Screens.TitleScreen;
import com.mathochist.mazegame.UI.ButtonHoverListener;
import com.mathochist.mazegame.UI.MainMenuUISkin;

public class EndScreen
extends DefaultScreen {
    private Stage stage;
    private Table table;
    private SpriteBatch batch;
    private MainMenuUISkin uiSkin;

    public EndScreen(Main game) {
        super(game);
        game.getTimerManager().resetTimer();
        game.getPlayerInventory().clear();
    }

    @Override
    public void show() {
        final Music backgroundMusic = Gdx.audio.newMusic(Gdx.files.internal("audio/title_screen.mp3"));
        backgroundMusic.setLooping(true);
        backgroundMusic.setVolume(0.5f);
        backgroundMusic.play();
        this.stage = new Stage(new FitViewport(Gdx.graphics.getWidth(), Gdx.graphics.getHeight()));
        Gdx.input.setInputProcessor(this.stage);
        this.table = new Table();
        this.table.setFillParent(true);
        this.stage.addActor(this.table);
        this.uiSkin = new MainMenuUISkin();
        this.batch = new SpriteBatch();
        Label gameOverLabel = new Label((CharSequence)"Game Over", this.uiSkin.getSkin());
        this.table.add(gameOverLabel).padBottom(10.0f);
        this.table.row();
        Label timeUpLabel = new Label("Time's Up!", this.uiSkin.getSkin(), "presents_grey");
        this.table.add(timeUpLabel).padBottom(50.0f);
        this.table.row();
        Button backToMenuButton = new Button(this.uiSkin.getSkin(), "back_to_MM");
        this.table.add(backToMenuButton).width(250.0f).height(50.0f);
        backToMenuButton.addListener(new ChangeListener(this){
            final /* synthetic */ EndScreen this$0;
            {
                this.this$0 = this$0;
            }

            @Override
            public void changed(ChangeListener.ChangeEvent changeEvent, Actor actor) {
                backgroundMusic.stop();
                this.this$0.game.setScreen(new TitleScreen(this.this$0.game));
            }
        });
        backToMenuButton.row();
        backToMenuButton.addListener(new ButtonHoverListener());
    }

    @Override
    public void render(float delta) {
        Gdx.gl.glClearColor(0.0f, 0.0f, 0.0f, 1.0f);
        Gdx.gl.glClear(16384);
        this.batch.begin();
        this.batch.end();
        this.stage.act(delta);
        this.stage.draw();
    }

    @Override
    public void resize(int width, int height) {
        this.stage.getViewport().update(width, height, true);
    }

    @Override
    public void dispose() {
        this.stage.dispose();
        this.uiSkin.dispose();
        this.batch.dispose();
    }

    @Override
    public boolean keyDown(int keycode) {
        return false;
    }

    @Override
    public boolean keyUp(int keycode) {
        return false;
    }
}

