/*
 * Decompiled with CFR 0.152.
 */
package com.mathochist.mazegame.Movement;

import com.mathochist.mazegame.Movement.KeyBinds;
import java.util.ArrayList;

public class KeyBuffer {
    private final float[] camera_move = new float[]{0.0f, 0.0f};
    private final ArrayList<Integer> keys_pressed = new ArrayList();

    private void normalize() {
        if (this.camera_move[0] != 0.0f || this.camera_move[1] != 0.0f) {
            float length = (float)Math.sqrt(this.camera_move[0] * this.camera_move[0] + this.camera_move[1] * this.camera_move[1]);
            this.camera_move[0] = this.camera_move[0] / length;
            this.camera_move[1] = this.camera_move[1] / length;
        }
    }

    public float[] getCameraMove() {
        this.normalize();
        return this.camera_move;
    }

    public void setCameraX(float x) {
        this.camera_move[0] = x;
    }

    public void setCameraY(float y) {
        this.camera_move[1] = y;
    }

    public void addCameraX(float x) {
        this.camera_move[0] = this.camera_move[0] + x;
    }

    public void addCameraY(float y) {
        this.camera_move[1] = this.camera_move[1] + y;
    }

    public void clear() {
        this.camera_move[0] = 0.0f;
        this.camera_move[1] = 0.0f;
    }

    public ArrayList<Integer> getKeysPressed() {
        return this.keys_pressed;
    }

    public void addKeyPressed(int keycode) {
        if (!this.keys_pressed.contains(keycode)) {
            this.keys_pressed.add(keycode);
        }
    }

    public void removeKeyPressed(int keycode) {
        this.keys_pressed.remove((Object)keycode);
    }

    public void updateCameraMovementFromKeys() {
        this.clear();
        for (int keycode : this.keys_pressed) {
            if (keycode == KeyBinds.MOVE_UP || keycode == KeyBinds.MOVE_UP_ALT) {
                this.addCameraY(1.0f);
            }
            if (keycode == KeyBinds.MOVE_DOWN || keycode == KeyBinds.MOVE_DOWN_ALT) {
                this.addCameraY(-1.0f);
            }
            if (keycode == KeyBinds.MOVE_LEFT || keycode == KeyBinds.MOVE_LEFT_ALT) {
                this.addCameraX(-1.0f);
            }
            if (keycode != KeyBinds.MOVE_RIGHT && keycode != KeyBinds.MOVE_RIGHT_ALT) continue;
            this.addCameraX(1.0f);
        }
    }

    public boolean isKeyPressed(int keycode) {
        return this.keys_pressed.contains(keycode);
    }
}

