/*
 * Decompiled with CFR 0.152.
 */
package com.mathochist.mazegame.Entities;

import com.badlogic.gdx.Gdx;
import com.badlogic.gdx.graphics.OrthographicCamera;
import com.badlogic.gdx.graphics.Texture;
import com.badlogic.gdx.graphics.g2d.Animation;
import com.badlogic.gdx.graphics.g2d.Sprite;
import com.badlogic.gdx.graphics.g2d.SpriteBatch;
import com.badlogic.gdx.graphics.g2d.TextureRegion;
import com.mathochist.mazegame.Entities.PlayerInventory.InventoryObject;
import com.mathochist.mazegame.Main;
import com.mathochist.mazegame.Movement.KeyBinds;
import com.mathochist.mazegame.Movement.KeyBuffer;
import com.mathochist.mazegame.Rendering.RenderBuffer;
import com.mathochist.mazegame.Rendering.RenderObject;
import com.mathochist.mazegame.World.GameWorld;

public class Player {
    private Texture spriteSheet;
    private final Animation<TextureRegion> walkUp;
    private final Animation<TextureRegion> walkDown;
    private final Animation<TextureRegion> walkLeft;
    private final Animation<TextureRegion> walkRight;
    private TextureRegion currentFrame;
    private final Sprite playerSprite;
    private final SpriteBatch screenBatch;
    private final int FRAME_COLS = 3;
    private final int FRAME_ROWS = 4;
    private float stateTime = 0.0f;
    private int direction = 0;
    private final KeyBuffer keyBuffer;
    private float x;
    private float y;
    private final OrthographicCamera camera;
    private final GameWorld world;
    private final Main game;
    private boolean is_sprinting = false;
    public static final float MOVE_SPEED = 300.0f;
    public static final float SPRITE_WIDTH = 19.0f;
    public static final float SPRITE_HEIGHT = 25.0f;
    public static final float INTERACTION_RANGE = 2.0f;

    public Player(Main game, OrthographicCamera camera, SpriteBatch batch, GameWorld world, float startX, float startY) {
        this.game = game;
        this.camera = camera;
        this.screenBatch = batch;
        this.world = world;
        this.spriteSheet = new Texture(Gdx.files.internal("player.png"));
        TextureRegion[][] tmp = TextureRegion.split(this.spriteSheet, this.spriteSheet.getWidth() / 3, this.spriteSheet.getHeight() / 4);
        TextureRegion[] frames = new TextureRegion[12];
        int index = 0;
        for (int i = 0; i < 4; ++i) {
            for (int j = 0; j < 3; ++j) {
                frames[index++] = tmp[i][j];
            }
        }
        this.walkUp = new Animation<TextureRegion>(0.15f, tmp[3]);
        this.walkLeft = new Animation<TextureRegion>(0.15f, tmp[1]);
        this.walkDown = new Animation<TextureRegion>(0.15f, tmp[0]);
        this.walkRight = new Animation<TextureRegion>(0.15f, tmp[2]);
        this.currentFrame = tmp[2][0];
        this.spriteSheet = new Texture("player.png");
        this.x = startX;
        this.y = startY;
        this.playerSprite = new Sprite(this.spriteSheet);
        this.keyBuffer = new KeyBuffer();
    }

    public void update(float game_delta, RenderBuffer renderBuffer) {
        float delta_time = Gdx.graphics.getDeltaTime();
        this.keyBuffer.updateCameraMovementFromKeys();
        int moveSpeed = 300;
        if (this.keyBuffer.isKeyPressed(KeyBinds.SPRINT)) {
            moveSpeed += 300;
            this.is_sprinting = true;
        } else {
            this.is_sprinting = false;
        }
        if (this.keyBuffer.isKeyPressed(KeyBinds.INTERACT)) {
            this.world.triggerInteractionByPixel(this.x, this.y, 2.0, this);
        }
        if (this.game.getPlayerInventory().hasItem(InventoryObject.ENERGY_DRINK)) {
            moveSpeed += 150;
        }
        float[] move = this.keyBuffer.getCameraMove();
        float deltaX = move[0] * delta_time * (float)moveSpeed;
        float deltaY = move[1] * delta_time * (float)moveSpeed;
        boolean[] collisionLayer = this.world.getCollisionLayer(this.x, this.y);
        if (deltaY > 0.0f && collisionLayer[0]) {
            deltaY = 0.0f;
        }
        if (deltaY < 0.0f && collisionLayer[1]) {
            deltaY = 0.0f;
        }
        if (deltaX < 0.0f && collisionLayer[2]) {
            deltaX = 0.0f;
        }
        if (deltaX > 0.0f && collisionLayer[3]) {
            deltaX = 0.0f;
        }
        if (move[0] != 0.0f || move[1] != 0.0f) {
            this.camera.translate(deltaX, deltaY);
            this.camera.update();
            this.stateTime += game_delta;
            if (move[1] > 0.0f) {
                this.currentFrame = this.walkUp.getKeyFrame(this.stateTime, true);
                this.direction = 3;
            } else if (move[0] < 0.0f) {
                this.currentFrame = this.walkLeft.getKeyFrame(this.stateTime, true);
                this.direction = 1;
            } else if (move[0] > 0.0f) {
                this.currentFrame = this.walkRight.getKeyFrame(this.stateTime, true);
                this.direction = 2;
            } else if (move[1] < 0.0f) {
                this.currentFrame = this.walkDown.getKeyFrame(this.stateTime, true);
                this.direction = 0;
            }
        } else {
            this.stateTime = 2.0f;
            switch (this.direction) {
                case 3: {
                    this.currentFrame = this.walkUp.getKeyFrame(this.stateTime, true);
                    break;
                }
                case 0: {
                    this.currentFrame = this.walkDown.getKeyFrame(this.stateTime, true);
                    break;
                }
                case 1: {
                    this.currentFrame = this.walkLeft.getKeyFrame(this.stateTime, true);
                    break;
                }
                case 2: {
                    this.currentFrame = this.walkRight.getKeyFrame(this.stateTime, true);
                }
            }
        }
        this.playerSprite.setRegion(this.currentFrame);
        this.keyBuffer.clear();
        this.x = this.camera.position.x - 19.0f;
        this.y = this.camera.position.y - 25.0f;
        this.render(game_delta, renderBuffer);
    }

    public void render(float delta, RenderBuffer renderBuffer) {
        this.playerSprite.setPosition(this.x, this.y);
        renderBuffer.addToBuffer(new RenderObject(this.playerSprite, this.screenBatch, (int)Math.ceil(this.world.pixelCoordsToTileIndex(this.x, this.y + this.world.getDeltaViewportHeight())[1])));
    }

    public void dispose() {
        this.spriteSheet.dispose();
    }

    public float getX() {
        return this.x;
    }

    public float getY() {
        return this.y;
    }

    public KeyBuffer getKeyBuffer() {
        return this.keyBuffer;
    }

    public void setPosition(float newX, float newY) {
        this.camera.position.set(newX, newY, 0.0f);
        this.camera.update();
    }

    public boolean isSprinting() {
        return this.is_sprinting;
    }
}

