/*
 * Decompiled with CFR 0.152.
 */
package com.mathochist.mazegame.Entities.NPCs;

import com.badlogic.gdx.Gdx;
import com.badlogic.gdx.graphics.g2d.Sprite;
import com.badlogic.gdx.graphics.g2d.SpriteBatch;
import com.badlogic.gdx.graphics.g2d.TextureAtlas;
import com.mathochist.mazegame.Entities.MapEntity;
import com.mathochist.mazegame.Entities.NPCs.INPC;
import com.mathochist.mazegame.Entities.Player;
import com.mathochist.mazegame.Main;
import com.mathochist.mazegame.Rendering.RenderBuffer;
import com.mathochist.mazegame.Rendering.RenderObject;
import com.mathochist.mazegame.UI.Hud;
import com.mathochist.mazegame.UI.Speech.SpeechType;
import com.mathochist.mazegame.World.GameWorld;

public class Librarian
extends MapEntity
implements INPC {
    public Librarian(Main game, SpriteBatch batch, TextureAtlas atlas, Integer TileX, Integer TileY, Integer Width, Integer Height, Boolean collidable) {
        super(game, batch, atlas, "librarian", TileX.intValue(), TileY.intValue(), Width.intValue(), Height.intValue(), collidable);
    }

    @Override
    public void render(GameWorld world, RenderBuffer buffer) {
        TextureAtlas.AtlasRegion librarianRegion = super.getAtlas().findRegion(super.getRegionName());
        Sprite librarianSprite = new Sprite(librarianRegion);
        librarianSprite.setPosition(super.getTileX() * (float)world.getMap().getTileWidth(), (float)Gdx.graphics.getHeight() - ((super.getTileY() + 1.0f) * (float)world.getMap().getTileHeight() + (float)world.tileDrawYOffset + world.getDeltaViewportHeight()));
        buffer.addToBuffer(new RenderObject(librarianSprite, super.getBatch(), (int)super.getTileY() + 2));
    }

    @Override
    public void renderPrompt(GameWorld world) {
    }

    @Override
    public void renderSpeech(String text, GameWorld world) {
    }

    @Override
    public boolean onInteract(Player p, GameWorld world, Hud worldHud) {
        worldHud.getSpeechBubbleManager().removeBubblesOfType(SpeechType.NPC_SPEECH);
        worldHud.getSpeechBubbleManager().createSpeechBubble(SpeechType.NPC_SPEECH, "Librarian: Shhh! This is a library!", 2000);
        return true;
    }

    @Override
    public void onInteractEnd(Player p, GameWorld world) {
    }

    @Override
    public boolean onCollision(GameWorld world) {
        return false;
    }
}

